import torch
import torch.nn as nn

class TwoHiddenTanhFNN(nn.Module):
    def __init__(self, input_size, hidden_size, output_size):
        super(TwoHiddenTanhFNN, self).__init__()
        self.fc1 = nn.Linear(input_size, hidden_size)
        self.fc2 = nn.Linear(hidden_size, hidden_size)
        self.fc3 = nn.Linear(hidden_size, output_size)
        
        # activations
        self.activation = nn.Tanh()
        
    def forward(self, x):
        x = self.activation(self.fc1(x))
        x = self.activation(self.fc2(x))
        x = self.fc3(x)
        return x

# Example function to compute gradients
def compute_gradients(model, x):
    x_copy = x.clone().detach().requires_grad_(True)  # Create a copy of x with requires_grad=True
    model.eval()  # Set the model to evaluation mode
    output = model(x_copy)
    model.zero_grad()  # Clear gradients
    output.backward(torch.ones_like(output))  # Backpropagate to compute gradients
    gradients = x_copy.grad.clone().detach()  # Clone and detach to prevent further gradient computation
    return gradients
